/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import slimeknights.tconstruct.library.client.data.GenericTextureGenerator;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.client.data.util.AbstractSpriteReader;
import slimeknights.tconstruct.library.client.data.util.DataGenSpriteReader;

public class MaterialPartTextureGenerator
extends GenericTextureGenerator {
    public static final String FOLDER = "textures";
    private final DataGenSpriteReader spriteReader;
    private final ExistingFileHelper existingFileHelper;
    private final AbstractPartSpriteProvider partProvider;
    private final AbstractMaterialSpriteProvider[] materialProviders;
    private static final List<IPartTextureCallback> TEXTURE_CALLBACKS = new ArrayList<IPartTextureCallback>();

    public MaterialPartTextureGenerator(FabricDataOutput output, ExistingFileHelper existingFileHelper, AbstractPartSpriteProvider spriteProvider, AbstractMaterialSpriteProvider ... materialProviders) {
        super((class_7784)output, FOLDER);
        this.spriteReader = new DataGenSpriteReader(existingFileHelper, FOLDER);
        this.existingFileHelper = existingFileHelper;
        this.partProvider = spriteProvider;
        this.materialProviders = materialProviders;
    }

    public String method_10321() {
        StringBuilder name = new StringBuilder();
        name.append("Material Part Generator - ");
        name.append(this.partProvider.getName());
        name.append(" - ");
        name.append(this.materialProviders[0].getName());
        for (int i = 1; i < this.materialProviders.length; ++i) {
            name.append(", ").append(this.materialProviders[i].getName());
        }
        return name.toString();
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        ArrayList futures = new ArrayList();
        MaterialPartTextureGenerator.runCallbacks(this.existingFileHelper, null);
        List<AbstractPartSpriteProvider.PartSpriteInfo> parts = this.partProvider.getSprites();
        if (parts.isEmpty()) {
            throw new IllegalStateException(this.partProvider.getName() + " has no parts, must have at least one part to generate");
        }
        for (AbstractMaterialSpriteProvider materialProvider : this.materialProviders) {
            Collection<AbstractMaterialSpriteProvider.MaterialSpriteInfo> materials = materialProvider.getMaterials().values();
            if (materials.isEmpty()) {
                throw new IllegalStateException(materialProvider.getName() + " has no materials, must have at least one material to generate");
            }
            BiConsumer<class_2960, class_1011> saver = (path, image) -> this.saveImage(cache, (class_2960)path, (class_1011)image);
            Predicate<class_2960> shouldGenerate = path -> !this.spriteReader.exists((class_2960)path);
            for (AbstractMaterialSpriteProvider.MaterialSpriteInfo material : materials) {
                for (AbstractPartSpriteProvider.PartSpriteInfo part : parts) {
                    if (!material.supportStatType(part.getStatType())) continue;
                    MaterialPartTextureGenerator.generateSprite(this.spriteReader, material, part, shouldGenerate, saver);
                }
            }
        }
        this.spriteReader.closeAll();
        this.partProvider.cleanCache();
        MaterialPartTextureGenerator.runCallbacks(null, null);
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public static void generateSprite(AbstractSpriteReader spriteReader, AbstractMaterialSpriteProvider.MaterialSpriteInfo material, AbstractPartSpriteProvider.PartSpriteInfo part, Predicate<class_2960> shouldGenerate, BiConsumer<class_2960, class_1011> saver) {
        class_2960 partPath = part.getPath();
        class_2960 materialTexture = material.getTexture();
        class_2960 spritePath = new class_2960(partPath.method_12836(), partPath.method_12832() + "_" + materialTexture.method_12836() + "_" + materialTexture.method_12832());
        if (shouldGenerate.test(spritePath)) {
            String fallback;
            class_1011 base = null;
            String[] stringArray = material.getFallbacks();
            int n = stringArray.length;
            for (int i = 0; i < n && (base = part.getTexture(spriteReader, fallback = stringArray[i])) == null; ++i) {
            }
            if (base == null) {
                base = part.getTexture(spriteReader, "");
            }
            if (base == null) {
                throw new IllegalStateException("Missing sprite at " + String.valueOf(partPath) + ".png, cannot generate textures");
            }
            class_1011 transformed = material.getTransformer().transformCopy(base);
            spriteReader.track(transformed);
            saver.accept(spritePath, transformed);
        }
    }

    public static void registerCallback(IPartTextureCallback callback) {
        TEXTURE_CALLBACKS.add(callback);
    }

    public static void runCallbacks(@Nullable ExistingFileHelper existingFileHelper, @Nullable class_3300 manager) {
        for (IPartTextureCallback callback : TEXTURE_CALLBACKS) {
            callback.accept(existingFileHelper, manager);
        }
    }

    public static interface IPartTextureCallback {
        public void accept(@Nullable ExistingFileHelper var1, @Nullable class_3300 var2);
    }
}

